<?php
session_start();
require 'config.php';

if ($_SERVER['REQUEST_METHOD'] != 'POST') {
	header($_SERVER['SERVER_PROTOCOL'] . ' 405 Method Not Allowed');
	die();
}
if (!isset($_POST['firstname']) || $_POST['firstname'] == '' || !isset($_POST['lastname']) || $_POST['lastname'] == '' || isset($_POST['status']) && !in_array($_POST['status'], ['student', 'tutor', 'teacher'])) {
	header($_SERVER['SERVER_PROTOCOL'] . ' 400 Bad Request');
	die();
}

$firstname = ucfirst(strtolower($_POST['firstname']));
$lastname = strtoupper($_POST['lastname']);

try {
	$pdo = new PDO($db_dsn, $db_user, $db_password);
} catch (PDOException $e) {
	print($e->getMessage());
	die();
}

if (isset($_POST['password'])) { //teacher
	if ($_POST['password'] == $teacher_password) {
		$_SESSION['id'] = 0;
		$_SESSION['firstname'] = $firstname;
		$_SESSION['lastname'] = $lastname;
		$_SESSION['status'] = 'teacher';
		header('Location: index.php');
	} else {
		header('Location: index.php?error=Mot de passe incorrect.');
	}
} else { //student or tutor
	$i = 0; $tables = ['Tutor', 'Student']; $user = NULL;
	while ($user == NULL && $i < count($tables)) {
		$table = $tables[$i];
		$stmt = $pdo->prepare("SELECT id FROM $table WHERE firstname = :firstname AND lastname = :lastname");
		$stmt->bindParam(':firstname', $firstname, PDO::PARAM_STR);
		$stmt->bindParam(':lastname', $lastname, PDO::PARAM_STR);
		$stmt->execute();
		$user = $stmt->fetch(PDO::FETCH_OBJ);
		if ($user) {
			$_SESSION['status'] = strtolower($table);
		}
		$i++;
	}
	if ($open_registration && !$user && isset($_POST['status'])) { //register new user
		$table = ucfirst($_POST['status']); //validated (addslashes not required)
		$stmt = $pdo->prepare("INSERT INTO $table (firstname, lastname) VALUES (:firstname, :lastname)");
		$stmt->bindParam(':firstname', $firstname, PDO::PARAM_STR);
		$stmt->bindParam(':lastname', $lastname, PDO::PARAM_STR);
		$stmt->execute();
		$stmt = $pdo->prepare("SELECT * FROM $table WHERE firstname = :firstname AND lastname = :lastname");
		$stmt->bindParam(':firstname', $firstname, PDO::PARAM_STR);
		$stmt->bindParam(':lastname', $lastname, PDO::PARAM_STR);
		$stmt->execute();
		$user = $stmt->fetch(PDO::FETCH_OBJ);
		$_SESSION['status'] = $_POST['status'];
	}
	if ($user) {
		$_SESSION['id'] = $user->id;
		$_SESSION['firstname'] = $firstname;
		$_SESSION['lastname'] = $lastname;
		header('Location: index.php');
	} else {
		header('Location: index.php?error=Utilisateur·rice inconnu·e.');
	}
}
?>
